Attribute VB_Name = "CtrlCard"
'****************************Motion control module *************************

    ' For developing an application system of great generality, extensibility and
    'convenient maintenance easily and swiftly, we envelop all the library functions
    'by category basing on the card function library

'*******************************************************************
Public Result As Integer     'retun value

Const MULTIPLE = 5           'ratio
 
Const MAXAXIS = 4            'max axis number

'******************************initial motion-card***************************

    'this function is boot of using motion-card
    'Return<=0 fail to initial motion-card
    'Return>0  Succeed in initial motion-card
    
'*******************************************************************
Public Function Init_Card() As Integer
       
    Result = adt8948_initial                'intiial motion-card
    
    If Result <= 0 Then
     
       Init_Card = Result
       
       Exit Function
       
    End If
       
    For i = 1 To MAXAXIS
         
       set_range 0, i, CLng(8000000 / 5)     'set range,set ratio as 5
       
       set_command_pos 0, i, 0               'set logic pos as 0
       
       set_actual_pos 0, i, 0                'set real pos as 0
       
       set_startv 0, i, 1000                 'set start-speed
         
       set_speed 0, i, 1000                  'set motion-speed
       
       set_acc 0, i, 625                     'set acceleration
     
    Next i
    
    Init_Card = Result
       
End Function

'************************** release of ADT8948 source occupied**************************

'    úаͷſƿĿ⺯Ǵ˺Ӧ

'    ʱ
'*****************************************************************
Public Function End_Board()

    Result = adt8948_end()
 
    End_Board = Result
 
End Function
'
'***********************set stop0 mode**********************
'
'Set mode of stop0 input signal
'
'para    axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'Defaule:     ineffective
'
'Return   0Correct                  1 Wrong
'  *****************************************************************
Public Function Setup_Stop0Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop0Mode = set_stop0_mode(0, axis, value, logic)
    
End Function


'************************set stop1 mode*********************
'**
'   Set mode of stop1 input signal
'
'   para axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'Defaule:     ineffective
'
'   Return   0Correct                  1 Wrong

'  *****************************************************************
Public Function Setup_Stop1Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop1Mode = set_stop1_mode(0, axis, value, logic)
    
End Function
'************************set stop2 mode*********************
'
'   Set mode of stop2 input signal
'
'   para axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'Defaule:     ineffective
'
'   Return   0Correct                  1 Wrong
'  *****************************************************************
Public Function Setup_Stop2Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop2Mode = set_stop2_mode(0, axis, value, logic)
    
End Function

'**********************set real position counter**********************

'cardno     Card number
'axis       Axis number1-4
'value      Input of pulse pattern
'0        A/B pulse input  1up/downPPIN/PMINpulse input
'dir        Counter direction
'0       A is over B or PPIN impulse input is up counted.
'          B is over A or PMIN impulse is down counted
'1       B is over A or PPIN impulse input is up counted
'          A is over B or PMIN impulse is down counted.
'freq      During double frequency of A/B input up/down impulse input is non-effective
'04-time frequency     12-time frequency        2No-time frequency
'Returning value: 0: Correct    1: False
'Initialized status: During A/B phase impulse input direction is of 0 and 4-time frequency.
'
'*******************************************************************
Public Function Actualcount_Mode(ByVal axis As Integer, ByVal value As Integer, ByVal dir As Integer, ByVal freq As Integer) As Integer
    
    Result = set_actualcount_mode(0, axis, value, dir, freq)
    
    Actualcount_Mode = Result

End Function

'**************************set pulse output mode*************************
'
'    set the mode of pulse output
'    paraaxis-axis number value-pulse mode 0pulse+pulse 1pulse + direction
'    Return=0 correctReturn=1 wrong
'    Default mode: Pulse + direction, with positive logic pulse
'    and positive logic direction input signal
'
'*******************************************************************
Public Function Setup_PulseMode(ByVal axis As Integer, ByVal value As Integer) As Integer

    Setup_PulseMode = set_pulse_mode(0, axis, value, 0, 0)
    
End Function

'****************************set limit signal mode***********************
''
'   set the mode of nLMT signal input along positive/ negative direction
'
'   para axisaxis number
'          value   0: sudden stop effective      1: decelerate stop effective
'         logic    0: low level effective           1: high level ineffective
'   Default mode: Apply positive and negative limits with low level
'
'   Return   0Correct                  1 Wrong
'  *****************************************************************
Public Function Setup_LimitMode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_LimitMode = set_limit_mode(0, axis, value, logic)
    
End Function


'*********************set COMP+counter as soft limit****************
'
'cardno      card number
'
'axis        axis number1-4
'
'Value       0: ineffective 1: effective
'
'Return      0Correct              1Wrong
'
'Default mode: ineffective
'NoticeSoftware position limiting always adopts acceleration to stop.
'Calculating value may be over set up value. Within setup sphere it must be considered.
'*******************************************************************
Public Function Setsoft_LimitMode1(ByVal axis As Integer, ByVal value As Integer) As Integer

    Result = set_softlimit_mode1(0, axis, value)

    Setsoft_LimitMode1 = Result
    
End Function

'*******************set COMP-counter as soft limit******************
'
'cardno      card number
'axis        axis number1-4
'Value       0: ineffective          1: effective
'Return      0Correct              1Wrong
'Default mode: ineffective
'NoticeSoftware position limiting always adopts acceleration to stop.
'Calculating value may be over set up value. Within setup sphere it must be considered.
'  *****************************************************************
Public Function Setsoft_LimitMode2(ByVal axis As Integer, ByVal value As Integer) As Integer

    Result = set_softlimit_mode2(0, axis, value)

    Setsoft_LimitMode2 = Result
    
End Function

'******************set COMP+/-counter*****************
'
'cardno      card number
'axis        axis number1-4
'Value       0: ineffective          1: effective
'Return      0Correct              1Wrong
'Default mode: ineffective
'NoticeSoftware position limiting always adopts acceleration to stop.
'Calculating value may be over set up value. Within setup sphere it must be considered.
'
'  *****************************************************************
Public Function Setsoft_LimitMode3(ByVal axis As Integer, ByVal value As Integer) As Integer

    Result = set_softlimit_mode3(0, axis, value)

    Setsoft_LimitMode3 = Result
    
End Function

'********************set nINPOS(in-position input sigal)******************
'
'cardno      card number
'axis        axis number1-4
'Value       0: ineffective       1: effective
'logic       0Effective when low electric level        1Effective when low electric level
'Return      0Correct              1Wrong
'Default mode :  noneffective, low electric level is effective

'*******************************************************************

Public Function Inpos_Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Result = set_inpos_mode(0, axis, value, logic)

    Inpos_Mode = Result
    
End Function

'********************set nALARM(alarm input sigal)******************

'cardno      card number
'axis        axis number1-4
'Value       0: ineffective       1: effective
'logic       0Effective when low electric level        1Effective when low electric level
'Return      0Correct              1Wrong
'Default mode :  noneffective, low electric level is effective

'*******************************************************************

Public Function Setup_AlarmMode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Result = set_alarm_mode(0, axis, value, logic)

    Setup_AlarmMode = Result
    
End Function


'***************************set speed***********************

'   according as para,judge whether is constant-speed
'   set range to set ratio
'   set start-speed ,motion-speed and acceleration
'para:     axis:   axis number
'startv:           start -speed
'speed:            motion -speed
'add:              acceleration
'dec:              decelerate
'ratio:            ratio
'mode:             mode
'     Return=0 correctReturn=1 wrong
'*******************************************************************
Public Function Setup_Speed(ByVal axis As Integer, ByVal startv As Long, ByVal speed As Long, ByVal add As Long, ByVal dec As Long, ByVal ratio As Long, ByVal mode As Integer) As Integer

   If (startv - speed >= 0) Then                  'constant-speed motion
    
        set_range 0, axis, 8000000 / ratio
    
        Result = set_startv(0, axis, startv / ratio)
    
        set_speed 0, axis, startv / ratio
        
    Else                                         'acceleration/deacceleration
    
        Select Case mode
            
        Case 0
            
            set_dec1_mode 0, axis, 0            'symmetry
                
            set_dec2_mode 0, axis, 0            'automatic deacceleration
    
            Result = set_range(0, axis, 8000000 / ratio)
                
            set_startv 0, axis, startv / ratio
                
            set_speed 0, axis, speed / ratio
                
            set_acc 0, axis, add / 125 / ratio
                
            set_ad_mode 0, axis, 0              'Strait line acceleration/deacceleration
             
       
         Case 1
            
             set_dec1_mode 0, axis, 1            'asymmetry
                
             set_dec2_mode 0, axis, 0            'automatic deacceleration
                
             Result = set_range(0, axis, 8000000 / ratio)
                
             set_startv 0, axis, startv / ratio
                
             set_speed 0, axis, speed / ratio
                
             set_acc 0, axis, add / 125 / ratio
                
             set_dec 0, axis, dec / 125 / ratio
                
            set_ad_mode 0, axis, 0              'Strait line acceleration/deacceleration
                
          Case 2
            
              Dim time As Double
                 
              Dim addvar As Double
                 
              Dim k As Long
               
             time = (speed - startv) / (add / 2)

             addvar = add / (time / 2)

             k = (62500000 / addvar) * ratio

             set_dec2_mode 0, axis, 0               'automatic deacceleration

             Result = set_range(0, axis, 8000000 / ratio)
        
             set_startv 0, axis, startv / ratio
             
             set_speed 0, axis, speed / ratio
        
             set_acc 0, axis, add / 125 / ratio
        
             set_acac 0, axis, k
        
             set_ad_mode 0, axis, 1                'S-curve acceleration/deceleration
                 
             Setup_Speed = Result
             
         End Select
             
     End If

End Function

'****************************single-axis motion***************************
'
'    drive one axis motion
'
'    para axis-axis numbervalue-pulse of motion
'
'    Return=0 correctReturn=1 wrong

'*******************************************************************
Public Function Axis_Pmove(ByVal axis As Integer, ByVal value As Long) As Integer
    
    Result = pmove(0, axis, value)
    
    Axis_Pmove = Result
    
End Function

'****************************single-axis continuous motion***************************
'
'    drive one axis continuous motion
'
'    para axis-axis numbervalue-pulse of motion
'
'    value: 0:positive direction    1:negative direction
'
'    Return=0 correctReturn=1 wrong
'
'*******************************************************************
Public Function Axis_Cmove(ByVal axis As Integer, ByVal value As Long) As Integer

    Result = continue_move(0, axis, value)
    
    Axis_Cmove = Result

End Function

'*****************************2-axis interpolation**************************

    'for any 2-axis linear interpolation
    
    'axis1,axis2       Interpolation axis number  1: x    2:y   3:z   4:w
        
    ' Moving distance   value1=pulse1,value2=pulse2
    
    'Return=0 correctReturn=1 wrong
    
    'Notice
'The interpolation speed takes the speed of the axis with smaller axis number between axis1 and axis2 as the standard.


'*******************************************************************
Public Function Interp_Move2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal value1 As Long, ByVal value2 As Long) As Integer

    Result = inp_move2(0, axis1, axis2, value1, value2)
    
    Interp_Move2 = Result
    
End Function

'*****************************3-axis interpolation**************************

    'Function:Three axes linear interpolation
  
     
   ' Moving distance  value1,value2,value3
    
    'Return=0 correctReturn=1 wrong
    
    'Notice
'The interpolation speed takes the speed of the axis with smallest axis number among axis1, axis2 and axis3 as the standard (axis1)


'*******************************************************************

Public Function Interp_Move3(ByVal axis1 As Long, ByVal axis2 As Long, ByVal axis3 As Long, ByVal value1 As Long, ByVal value2 As Long, ByVal value3 As Long) As Integer

    Result = inp_move3(0, axis1, axis2, axis3, value1, value2, value3)
    
    Interp_Move3 = Result
    
End Function




'*********************Clockwise CW circular interpolation********************

'axis1,axis2    1X   2:Y   3Z  4:W
' x,y        Terminal position of Arc SR (corresponding to starting point)
' i,j        Central point position of SR circle arc (corresponding to starting point)
'return      0Correct     1False

'*******************************************************************

Public Function Interp_Arc(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long) As Integer

     Interp_Arc = inp_cw_arc(0, axis1, axis2, X, Y, i, j)

End Function

'**********************Clock against CCW circular interpolation**********************

'axis1,axis2     1X    2Y    3Z   4W
'x,y             Terminal position of Arc SR (corresponding to starting point)
'i,j             Central point position of SR circle arc (Corresponding to starting point)
'return      0Correct     1False

'*******************************************************************

Public Function Interp_CcwArc(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long) As Integer

     Interp_CcwArc = inp_ccw_arc(0, axis1, axis2, X, Y, i, j)

End Function

'*********************position counter variable ring****************

'axis     axis number1-4
'Value    0: ineffective       1: effective
'return   0Correct     1False
'Default mode :  noneffective

'*******************************************************************

Public Function SetCircle_Mode(ByVal axis As Integer, ByVal value As Integer) As Integer

     Result = set_circle_mode(0, axis, value)

     SetCircle_Mode = Result

End Function

'*******************Setup of signal wave filtering function**********************

'   number  input type
''1:         LMT ?LMT - ?STOP0?STOP1
'2:        STOP2
'3:         nINPOS?nALARM
'4:          nIN
 '   Set the filtering state of the four types input signals above
' '  value        0: Wave filter is ineffective           1: Wave filter is effective
'   Default mode: ineffective

'*******************************************************************

Public Function Setup_InputFilter(ByVal axis As Integer, ByVal number As Integer, ByVal value As Integer) As Integer

     Result = set_input_filter(0, axis, number, value)
     
     Setup_InputFilter = Result
     
End Function


'*********************setup of wave filter time constant of input signal********************

'axis       axis number(1-4)

'value      maximum noise scope deleted ,   delay of input signal

'*********************************************************************
Public Function Setup_FilterTime(ByVal axis As Integer, ByVal value As Integer) As Integer

     Result = set_filter_time(0, axis, value)
     
     Setup_FilterTime = Result
     
End Function

'**************************** set lockmode **********************
'function:lock the logical position and real position for all axis
'para:
'    axis-reference axis
'    regi-register mode   |0:logical position
'                          |1:real position
'    logical-level signal |0: from high to low
'                          |1:from low to high
'retutrn 0: correct 1: wrong
'Note: Use IN signal of specific axis as the trigger signal
'
'*******************************************************************/
Public Function Setup_LockPosition(ByVal axis As Integer, ByVal regi As Integer, ByVal logical As Integer) As Integer
    
    Result = set_lock_position(0, axis, regi, logical)
    
    Setup_LockPosition = Result
    
End Function



'************************stoping dring*************************

 'stop dring in the way of emergency or decelerate
 'para    axis-axis number
 '          mode-stop mode
 'value     0emergency stop
 '          1decelerate stop
 'return    0: correct    1: wrong

'*******************************************************************
Public Function StopRun(ByVal axis As Integer, ByVal mode As Integer) As Integer

    If mode = 0 Then             'emergency stop
        
        Result = sudden_stop(0, axis)
        
    Else                         'decelerate stop
    
        Result = dec_stop(0, axis)
    
    End If

End Function


'****************************get status of motion***********************

  ' get status of single-axis motion or interpolation
  '
  ' paraaxis-axis numbervalue-Indicator of motion status(0Drive completed,Non-0: Drive in process)
  '
  ' mode(0-single-axis motion1interpolation)
  '
  ' Return=0 correctReturn=1 wrong


'*******************************************************************
Public Function Get_MoveStatus(ByVal axis As Integer, value As Integer, ByVal mode As Integer) As Integer

    If mode = 0 Then         ' status of single-axis motion
    
        GetMove_Status = get_status(0, axis, value)
        
    Else                     'status of interpolation
    
        GetMove_Status = get_inp_status(0, value)
        
    End If
    
End Function

'*************************get synchronous action state***********************
'function:get synchronous action state
'para:
'         cardno       card number
'         axis         axis number
'         status-0|haven't run synchronous
'                 1|run synchronous
'retutrn 0: correct 1: wrong
'Note: This function could tell whether the position lock has been executed

'******************************************************************/
Public Function Get_LockStatus(ByVal axis As Integer, status As Integer) As Integer

    Result = get_lock_status(0, axis, status)
 
    Get_LockStatus = Result
    
End Function

'**************************home diving status***********************
'function:get the information of home position,judge the error message
'pare:
'    cardno      card number
'    axis        axis number
'    statusdrive status 0|finish driving
'                         1|driving
'    errerror message   0|correct
'                         1|wrong
'retutrn 0: correct 1: wrong
'******************************************************************/
Public Function Get_HomeStatus(ByVal axis As Integer, status As Integer, err As Integer) As Integer

    Result = get_home_status(0, axis, status, err)
    
    Get_HomeStatus = Result

End Function


'************************Get the error information of home position return ************************
'Function: Get the error information of home position return
'para:
'      errerror message
'                0|correct
'                not 0|wrong
'D0:                comp+
'D1:                comp-
'D2:                LMT+
'D3:                LMT-
'D4:                servo alarm
'D5:                sudden stop
'D6:                Z-phase signal reach advance
'retutrn 0: correct 1: wrong
'******************************************************************/
Public Function Get_HomeError(ByVal axis As Integer, err As Integer) As Integer

    Result = get_home_error(0, axis, err)

    Get_HomeError = Result
    
End Function

'*************************deceleration enable************************

'the function allowable deceleration during driving

'retutrn         0correct          1wrong

'******************************************************************

Public Function AllowDec() As Integer
 
    Result = inp_dec_enable(0)

    AllowDec = Result
    
End Function

'**************************deceleration disable***********************


'the function for deceleration disable during driving

'retutrn         0correct          1wrong

'*****************************************************************

Public Function ForbidDec() As Integer
 
    Result = inp_dec_disable(0)

    ForbidDec = Result
    
End Function


'**********************getting information about mistaken stop on all axes********************

'This function is  for getting information about the axis stop
'value:   0:no error   no-0Value of two bytes
     
'retutrn         0correct          1wrong

'*******************************************************************

Public Function Get_ErrorInf(ByVal axis As Integer, value As Integer) As Integer
 
    Result = get_stopdata(0, axis, value)

    Get_ErrorInf = Result
    
End Function

'***********************Get the status of continuous interpolation***********************

'This function is to get the writable status of continuous interpolation
' valueIndex of interpolation status  0: Unwritable  1: Writable
'retutrn 0: correct 1: wrong


'*******************************************************************

Public Function Get_AllowInpStatus(value As Integer) As Integer
 
    Result = get_inp_status2(0, value)

    Get_AllowInpStatus = Result
    
End Function


'***************************set deceleration type***********************

'deceleration for symmetry/non-symmetry/automatic/manual

'mode1: 0:symmetry     1non-symmetry

'mode2: 0:automatic           1manual

'retutrn         0correct          1wrong

'*******************************************************************

Public Function Set_DecMode(ByVal axis As Integer, ByVal mode1 As Integer, ByVal mode2 As Integer) As Integer

    Dim Result1 As Integer
    
    Dim Result2 As Integer
     
    Result1 = set_dec1_mode(0, axis, mode1)
    
    Result2 = set_dec2_mode(0, axis, mode2)
    
    Set_DecMode = Result1 & Result2
    
End Function

'***************************set deceleration point*************************

'  set deceleration point during manual deceleration

'  retutrn         0correct          1wrong

'*******************************************************************

Public Function Set_DecPos(ByVal axis As Integer, ByVal value As Long, ByVal startv As Long, ByVal speed As Long, ByVal add As Long) As Integer
     
    Dim addtime As Double
    
    Dim DecPulse As Long
    
    addtime = (speed - startv) / add

    DecPulse = ((startv + speed) * addtime) / 2
    
    Result = set_dec_pos(0, axis, value - DecPulse)

    Set_DecPos = Result
    
End Function

'***************************read input******************************
'
' This function is to read the single input point
'
' paranumber-input port(0 ~ 39)
'
' Return0  low level1  high level-1  error
'
'*******************************************************************
Public Function Read_Input(ByVal number As Integer) As Integer
    
    Read_Input = read_bit(0, number)
    
End Function

'***************************output****************************
'
'    This function is to output single point signal
'
'    para number-output port(0 ~ 15),value 0-low level1high level
'
'    return:   0: correct  1: wrong
'*******************************************************************
Public Function Write_Output(ByVal number As Integer, ByVal value As Integer) As Integer

    Write_Output = write_bit(0, number, value)
    
End Function

'************************set position counter*************************

    ' This function is to set the logical position and actual position
    ' paraaxis- axis number,      pos- Value of position
    ' mode 0Set the logical position,  Non-0Set the actual position
' Return=0 correctReturn=1 wrong


'*******************************************************************
Public Function Setup_Pos(ByVal axis As Integer, ByVal pos As Long, ByVal mode As Integer) As Integer

    If mode = 0 Then
    
        Result = set_command_pos(0, axis, pos)
        
    Else
    
        Result = set_actual_pos(0, axis, pos)
        
    End If
    
End Function

'***************************COMP+register setting*************************

'   cardno       card number
'    axis        axis number
'    value        range-2147483648~+2147483647
'retutrn 0: correct 1: wrong

'*******************************************************************


Public Function Setup_Comp1(ByVal axis As Integer, ByVal value As Long)

    Result = set_comp1(0, axis, value)
    
    Setup_Comp1 = Result

End Function

'**************************set COMP- register**************************

'   cardno   card number
'      axis       axis number
'      value      range-2147483648~+2147483647
'retutrn 0: correct 1: wrong

'*******************************************************************

Public Function Setup_Comp2(ByVal axis As Integer, ByVal value As Long)

    Result = set_comp2(0, axis, value)
    
    Setup_Comp2 = Result

End Function


'***************************Set the mode of fixed linear speed************************
'Function: Set the mode of fixed linear speed
'para:
'    cardno card number
'    mode-0| not use the fixed linear speed        1| Use the fixed linear speed
'retutrn 0: correct 1: wrong
'    Note: Linear speed means vector speed; fixed linear speed could ensure the composite speed to be fixed during the interpolation

'*******************************************************************/
Public Function Setup_VectorSpeed(ByVal mode As Integer) As Integer

    Result = set_vector_speed(0, mode)
    
    Setup_VectorSpeed = Result
    
End Function


'******************************set home position mode*************************
'Function: Set the back-to-home mode of specific axis
'para:
'       logical0-stop0|0: stop with low level
'                  |1: stop with high level
'                  |-1: ineffective
'       logical1-stop1|0: stop with low level
'                  |1: stop with high level
'                  |-1: ineffective
'       logical2-stop2|0: stop with low level
'                  |1: stop with high level
'                  |-1: ineffective
'       0ffset- 0| Do not offset from home             1| Offset from home
'       dir0-Direction |0:Positive                   |1:Negative
'       dir1-Direction |0:Positive                   |1:Negative
'       dir2-Direction |0:Positive                   |1:Negative
'       offsetdir-Offset direction |0:Positive               |1:Negative                speed-Low search speed, it's required to be lower than start velocity of high speed
'       reset-Reset the counter?|0: Yes        |1: No
'return         0correct          1wrong
'Note:
'        (1) Zero-return is divided into four steps:
'           |The first step: swiftly approach stop0 (logical0 close origin setup);
'           |The second step: slowly approach stop1 (logical1 origin setup);
'           |The third step: slowly approach stop2 (logical2 encoder Z-phase);
'           |The fourth step: Deviation range (For working origin);
'        (2) The above four steps can decide whether to be carried out by choosing among logical0, logical1logical2 and offset
'        (3) Able to use a proximity switch to act as several signals
'
'******************************************************************/
Public Function Setup_HomeMode(ByVal axis As Integer, ByVal speed As Long, ByVal logical0 As Integer, ByVal logical1 As Integer, ByVal logical2 As Integer, ByVal offset As Integer, ByVal dir0 As Integer, ByVal dir1 As Integer, ByVal dir2 As Integer, ByVal offsetdir As Integer, ByVal clear As Integer, ByVal pulse As Long) As Integer

    Result = set_home_mode(0, axis, speed, logical0, logical1, logical2, offset, dir0, dir1, dir2, offsetdir, clear, pulse)

    Setup_HomeMode = Result
    
End Function



'************************Get the motion information ***********************
'This function is to reflect a feedback of current logic position, actual position and operating speed of axis
'paraaxis-Axis number., LogPos-Logical position, ActPos-Actual position, Speed- driving speed
'Return=0 correctReturn=1 wrong

'***********************************************************/
Public Function Get_CurrentInf(ByVal axis As Integer, LogPos As Long, ActPos As Long, speed As Long) As Integer

    Result = get_command_pos(0, axis, LogPos)
    
        get_actual_pos 0, axis, ActPos
    
        get_speed 0, axis, speed

    Get_CurrentInf = Result
    
End Function

'**************************get lock position**************************
'Function: Get the locked position
'para:
'    cardno      card number
'    axis        axis number
'    pos         lock position
'Return      0Correct              1Wrong

'******************************************************************
Public Function Get_LockPosition(ByVal axis As Integer, pos As Long) As Integer

    Result = get_lock_position(0, axis, pos)
    
    Get_LockPosition = Result
    
End Function


'************************ Function of library function's version number **************************
'Function: Get the version of library function
'para:
'     ver-Version number (The first two numbers are the major version numbers, the last two numbers are secondary version numbers)
'Return      0Correct              1Wrong

'******************************************************************
Public Function Get_LibVision(ver As Integer) As Integer

    Result = get_lib_vision(ver)
    
    Get_LibVision = Result
    
End Function


'************************Quantitative drive function of external signal **********************
'function: Quantitative drive function of external signal
'para:
'    cardno      card number
'    axis       axis number
'    pulse pulse
'Return      0Correct              1Wrong
'    Note: (1) Send out quantitative pulse, but the drive does not start immediately until the external signal level changes
'     (2)Ordinary button and handwheel are acceptable.

'******************************************************************/
Public Function Manu_Pmove(ByVal axis As Integer, ByVal pulse As Long) As Integer

    Result = manual_pmove(0, axis, pulse)
    
    Manu_Pmove = Result
    
End Function

'************************Continuous drive function of external signal **********************
'function: Continuous drive function of external signal
'para:
'    cardno     card number
'    axis       axis number
'Return      0Correct              1Wrong
'    Note: (1) Send out fixed pulse, but the drive does not start immediately until the level of external signal changes
'         (2) Ordinary button and handwheel are acceptable.
'
'******************************************************************/
Public Function Manu_Continue(ByVal axis As Integer) As Integer

    Result = manual_continue(0, axis)
    
    Manu_Continue = Result

End Function


'***********************Shut down the enabling of external signal drive ***********************
'function: Shut down the enabling of external signal drive
'para:
'    cardno     card number
'    axis       axis number
'Return      0Correct              1Wrong

'******************************************************************/
Public Function Manu_Disable(ByVal axis As Integer) As Integer

    Result = manual_disable(0, axis)

    Manu_Disable = Result
    
End Function


'*********************Command type two axes stepping interpolation setup*********************
'Function:Set the data of two axes command stepping interpolation
'para:
'    The same with the 2-axis interpolation function
'Return      0Correct              1Wrong
'    Functional description: Send out data of stepping interpolation, the drive does not start but waiting for drive command function
'
'******************************************************************/
Public Function Inp_Command2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer

    Result = inp_step_command2(0, axis1, axis2, pulse1, pulse2)

    Inp_Command2 = Result

End Function

'********************** Command type three axes stepping interpolation setup *********************
'Function: Set the data of three axes command stepping interpolation
'para:
'    The same with three-axis interpolation function
'Return      0Correct              1Wrong
'    Functional description: Send out data of stepping interpolation, the drive does not work but waiting for drive command function

'******************************************************************/
Public Function Inp_Command3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer

    Result = inp_step_command3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3)
    
    Inp_Command3 = Result
    
End Function


'*********************** Stepping interpolation command driving function**********************
'function: Execute command stepping interpolation in single step
'para:
'    cardno      card number
'Return      0Correct              1Wrong
'    Functional description: Drive the stepping motion in the form of command according to the parameter of the set function
'
'******************************************************************/
Public Function Inp_StepMove() As Integer

    Result = inp_step_move(0)
    
    Inp_StepMove = Result
    
End Function


'********************* Setting function of 2-axis signal stepping interpolation**********************
'Function: Set the data of 2-axis signal stepping interpolation
'parameter:
'    The same with the interpolation function of 2-axis
'Return      0Correct              1Wrong
'    Functional description: Send out data of stepping interpolation, the drive does not work but waiting for the external signal level to drop to low level

'*******************************************************************/
Public Function Inp_Signal2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer

    Result = inp_step_signal2(0, axis1, axis2, pulse1, pulse2)
    
    Inp_Signal2 = Result
 
End Function

'*********************Setting function of three-axis signal stepping interpolation *********************
'function: Set the data of three-axis stepping interpolation
'para:
'    The same with the three-axis interpolation function
'return value         0correct          1wrong
'    Functional description: Send out data of stepping interpolation, the drive does not work but waiting for the external signal level to drop to low level
'
'******************************************************************/
Public Function Inp_Signal3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer

    Result = inp_step_signal3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3)
    
    Inp_Signal3 = Result
    
End Function


'*************************Stop stepping interpolation **************************
'function: Stop the stepping interpolation
'para:
'    cardno      card number
'    axis        axis number
'return value         0correct          1wrong
'    Note: Axis that is in the state of stepping interpolation must carry out the stop command of stepping interpolation before going to other drives
'
'******************************************************************/
Public Function Inp_Stop(ByVal axis As Integer) As Integer

    Result = inp_step_stop(0, axis)

    Inp_Stop = Result

End Function


'****************************back-home drive function *************************
'function: Back-home by following the set mode
'para:
'    cardno      card number
'    axis        axis number
'return value         0correct          1wrong
'
'******************************************************************/
Public Function Move_Home(ByVal axis As Integer) As Integer

    Result = home(0, axis)

    Move_Home = Result

End Function

'*************************** Clear back-to-home error information ***********************
'function: Clear error information of home
'para:
'    cardno card number
'    axis axis number
'return value  0: correct   1: wrong
'
'******************************************************************/
Public Function Clear_HomeError(ByVal axis As Integer) As Integer

    Result = clear_home_error(0, axis)

    Clear_HomeError = Result

End Function



'************************** Single axis follow moving setting function************************
'function: Function of IN simultaneous movement setup
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        pulse-pulse of active axis
'        pulse1-pulse of drive axis
'        logical-Electricity level logic of IN signal (0:low electric 1:high electric)           mode-The active axis has moved? 0| Yes  1| No
'        return value         0correct          1wrong
'    Note: Use IN signal of active axis as trigger signal
'
'*******************************************************************/
Public Function Set_InMove1(ByVal axis As Integer, ByVal axis1 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal logical As Integer, ByVal mode As Integer) As Integer
    
    Result = set_in_move1(0, axis, axis1, pulse, pulse1, logical, mode)
    
    Set_InMove1 = Result

End Function


'**************************2-axis follow moving setting function *************************
'function: Function of IN simultaneous movement setup
'para:
'        axis-active axis number
'        axis1-driven axis number
'        axis2-driven axis number
'pulse-pulse of active axis
'        pulse1-pulse of drive axis1
'        pulse2-pulse of drive axis2
'        logical-level signal |0: From high to low        |1: From low to high               mode-The active axis has moved? 0| Yes  1| No
'
'return value         0correct          1wrong
'    Note: Use IN signal of active axis as trigger signal
'
'*******************************************************************/
Public Function Set_InMove2(ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal logical As Integer, ByVal mode As Integer) As Integer

    Result = set_in_move2(0, axis, axis1, axis2, pulse, pulse1, pulse2, logical, mode)

    Set_InMove2 = Result

End Function

'*************************3-axis follow moving setting function*************************
'function: Function of IN simultaneous movement setup
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        axis2-driven axis number2
'        axis3-driven axis number3
'        pulse-pulse of active axis
'        pulse1-pulse of driven axis 1
'        pulse2-pulse of driven axis 2
'        pulse3-pulse of driven axis 3
'        logical-level signal |0: From high to low        |1: From low to high
'        mode-The active axis has moved? 0| Yes  1| No
'return value         0correct          1wrong
'    Note: Use IN signal of active axis as trigger signal
'
'********************************************************************/
Public Function Set_InMove3(ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal logical As Integer, ByVal mode As Integer) As Integer

    Result = set_in_move3(0, axis, axis1, axis2, axis3, pulse, pulse1, pulse2, pulse3, logical, mode)
    
    Set_InMove3 = Result

End Function

'**************************Single axis follow stopping setting function *************************
'function: Set the IN synchronization action
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        logical-level signal |0: From high to low   |1: From low to high
'        mode-active axis stop? |0:yes             |1:no
'return value 0: correct    1: wrong
'Note:
'        Signal changes detected, dead axle has stopped and the driving status of drive axle can be set
'
'*******************************************************************/
Public Function Set_InStop1(ByVal axis As Integer, ByVal axis1 As Integer, ByVal logical As Integer, ByVal mode As Integer) As Integer
    
    Result = set_in_stop1(0, axis, axis1, logical, mode)
    
    Set_InStop1 = Result

End Function

'*************************2-axis follow stopping setting function *************************
'function: Set the IN synchronization action
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        axis1-driven axis number2
'        logical-level signal |0: From high to low   |1: From low to high
'       mode-active axis stop? |0:yes              |1:no
'return value         0correct          1wrong
'Note:
'        Signal changes detected, dead axle has stopped and the driving status of drive axle can be set
'
'******************************************************************/
Public Function Set_InStop2(ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal logical As Integer, ByVal mode As Integer) As Integer
    Result = set_in_stop2(0, axis, axis1, axis2, logical, mode)

    Set_InStop2 = Result

End Function

'*************************3-axis follow stopping setting function************************
'function: Set the IN synchronization action
'para:
'        axis-active axis number
'        logical-level signal |0: From high to low   |1: From low to high
'        mode-active axis stop? |0:yes             |1:no
'return value 0: correct 1: wrong
'Note:
'        Signal changes detected, dead axle has stopped and the driving status of drive axle can be set
'
'
'*******************************************************************/
Public Function Set_InStop3(ByVal axis As Integer, ByVal logical As Integer, ByVal mode As Integer) As Integer

    Result = set_in_stop3(0, axis, logical, mode)

    Set_InStop3 = Result

End Function
'********************Setting of single-axis drive when arriving at the target position*********************
'function: Setting of single-axis drive when arriving at the target position
'para:
'        axis-active axis number
'        axis2-driven axis number
'        pulse1-pluse of active axis 1
'        pulse2-pluse of driven axis 2
'        regi-0|comp+  Select the compare register       1|comp-
'        term-0|>=  Select the compare register          1|<
'return value         0correct          1wrong
'
'******************************************************************/
Public Function Setup_Pmove1(ByVal axis As Integer, ByVal axis1 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal regi As Integer, ByVal term As Integer) As Integer
    
    Result = set_comp_pmove1(0, axis, axis1, pulse, pulse1, regi, term)

    Setup_Pmove1 = Result

End Function
'********************Setting of two-axis drive when arriving at the target position**********************
'function: Setting of two-axis drive when arriving at the target position
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        axis2-driven axis number2
'        pulse-pulse of active axis
'        pulse1-pulse of driven axis1
'        pulse2-pulse of driven axis2
'        regi-0|comp+  Select the compare register       1|comp-
'        term-0|>=  Select the compare register      1|<
'return value         0correct          1wrong
'
'*****************************************************************/
Public Function Setup_Pmove2(ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal regi As Integer, ByVal term As Integer) As Integer

    Result = set_comp_pmove2(0, axis, axis1, axis2, pulse, pulse1, pulse2, regi, term)

    Setup_Pmove2 = Result

End Function


'*********************Setting of three-axis drive when arriving at the target position *********************
'function: Setting of three-axis drive when arriving at the target position
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        axis2-driven axis number2
'        axis2-driven axis number3
'        pulse-pulse of active axis
'        pulse1-pulse of driven axis1
'        pulse2-pulse of driven axis 2
'        pulse3-pulse of driven axis3
'        regi-0|comp+  Select the compare register       1|comp-
'        term-0|>=  Select the compare register      1|<
'return value         0correct          1wrong
'
'*******************************************************************/
Public Function Setup_Pmove3(ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal regi As Integer, ByVal term As Integer) As Integer
    
    Result = set_comp_pmove3(0, axis, axis1, axis2, axis3, pulse, pulse1, pulse2, pulse3, regi, term)
    
    Setup_Pmove3 = Result
    
End Function

'**********************Setting of stopping drive when arriving at the target position*********************
'function: Setting of stopping drive when arriving at the target position
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        pulse-target position of active axis
'        regi-0|comp+  Select the compare register       1|comp-
'        term-0|>=  Select the compare register      1|<
'        mode-|0: active axis stop                   |1: active axis does not stop
'return value         0correct          1wrong
'
'*******************************************************************/
Public Function Setup_Stop1(ByVal axis As Integer, ByVal axis1 As Integer, ByVal pulse As Long, ByVal regi As Integer, ByVal term As Integer, ByVal mode As Integer) As Integer

    Result = set_comp_stop1(0, axis, axis1, pulse, regi, term, mode)

    Setup_Stop1 = Result

End Function

'*********************Setting of stopping drive when arriving at the target position*********************
'function: Setting of stopping drive when arriving at the target position
'para:
'        axis-active axis number
'        axis1-driven axis number1
'        axis2-driven axis number2
'        pulse-target position of active axis
'        regi-0|comp+  Select the compare register       1|comp-
'        term-0|>=  Select the compare register      1|<
'        mode-|0: active axis stop                   |1: active axis does not stop
'return value         0correct          1wrong

'******************************************************************/
Public Function Setup_Stop2(ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse As Long, ByVal regi As Integer, ByVal term As Integer, ByVal mode As Integer) As Integer

    Result = set_comp_stop2(0, axis, axis1, axis2, pulse, regi, term, mode)

    Setup_Stop2 = Result

End Function
''***********************Setting of stopping drive when arriving at the target position*******************
'function: Setting of stopping drive when arriving at the target position
'para:
'        axis-active axis number
'        pulse-target position of active axis
'        regi-0|comp+  Select the compare register        1|comp-
'        term-0|>=  Select the compare register          1|<
'        mode-|0: active axis stop                   |1: active axis does not stop
'return value         0correct          1wrong
'
'*******************************************************************/
Public Function Setup_Stop3(ByVal axis As Integer, ByVal pulse As Long, ByVal regi As Integer, ByVal term As Integer, ByVal mode As Integer) As Integer
    
    Result = set_comp_stop3(0, axis, pulse, regi, term, mode)

    Setup_Stop3 = Result
    
End Function

'------------------------Composite drives --------------------------
'Note: The following functions are added for the convenience of customers
'-----------------------------------------------------------

'***************************** Symmetrical relative movement of single-axis *********************
'function: Refer to the current position and perform quantitative movement in the symmetrical acceleration/deceleration
'para:
'      cardno -card number
'      axis ---axis number
'      pulse --pulse
'      lspd --- Low speed
'      hspd --- High speed
'      tacc--- Time of acceleration (Unit: sec)
'      vacc --- Change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'*******************************************************************/
Public Function Symmetry_RelativeMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = symmetry_relative_move(0, axis, pulse, lspd, hspd, tacc, vacc, mode)

    Symmetry_RelativeMove = Result
End Function
'/*************************** Symmetrical absolute movement of single-axis ***********************
'function: Refer to the position of zero point and perform quantitative movement in the symmetrical acceleration/deceleration
'para:
'      cardno -card number
'      axis ---axis number
'      pulse --pulse
'      lspd --- Low speed
'      hspd --- High speed
'      tacc--- Time of acceleration (Unit: sec)
'      vacc --- Change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'********************************************************************/
Public Function Symmetry_AbsoluteMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
    
    Result = symmetry_absolute_move(0, axis, pulse, lspd, hspd, tacc, vacc, mode)
    
    Symmetry_AbsoluteMove = Result
    
End Function

'**************************asymmetrical relative movement of single-axis************************
'function: Refer to the current position and perform quantitative movement in the asymmetrical acceleration/deceleration
'para:
'  cardno -card number
'  axis ---axis number
'  pulse --pulse
'  lspd --- Low speed
'  hspd --- High speed
'      tacc--- Time of acceleration (Unit: sec)
'      tdec--- Time of deceleration (Unit: sec)
'      vacc--- Change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'return value         0correct          1wrong
'
'*********************************************************************/
Public Function Unsymmetry_RelativeMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_relative_move(0, axis, pulse, lspd, hspd, tacc, tdec, vacc, mode)

    Unsymmetry_RelativeMove = Result

End Function

'*************************asymmetrical absolute movement of single-axis*************************
'function: Refer to the position of zero point and perform quantitative movement in the asymmetrical acceleration/deceleration
'para:
'      cardno-card number
'      axis---axis number
'pulse --pulse
'  lspd --- Low speed
'  hspd --- High speed
'      tacc--- Time of acceleration (Unit: sec)
'      tdec--- Time of deceleration (Unit: sec)
'      vacc--- Change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'return value         0correct          1wrong
'
'********************************************************************/
Public Function Unsymmetry_AbsoluteMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_absolute_move(0, axis, pulse, lspd, hspd, tacc, tdec, vacc, mode)

    Unsymmetry_AbsoluteMove = Result
    
End Function

'**********************Relative movement of two-axis symmetrical linear interpolation ********************
'function: Refer to current position and perform linear interpolation in symmetrical acceleration/deceleration
'para:
'      cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      pulse1-- pulse 1
'      pulse2-- pulse 2
'lspd --- Low speed
'  hspd --- High speed
'      tacc--- Time of acceleration (Unit: sec)
'      vacc--- Change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'******************************************************************/
Public Function Symmetry_RelativeLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = symmetry_relative_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode)

    Symmetry_RelativeLine2 = Result

End Function
'********************Two axes symmetric linear interpolation absolute moving**********************
'function: Refer to the position of zero point and perform linear interpolation in symmetrical acceleration/deceleration
'para:
'      cardno -card number
'      axis1 ---axis number1
'      axis2 ---axis number2
'         pulse1-pulse of axis 1
'          pulse2-- pulse of axis 2
'lspd --- Low speed
'      hspd --- High speed
'         tacc--- Time of acceleration (Unit: sec)
'         vacc--- Change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct    1: wrong
'
'******************************************************************/
Public Function Symmetry_AbsoluteLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
    
    Result = symmetry_absolute_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode)
    
    Symmetry_AbsoluteLine2 = Result

End Function
'******************** Two axes asymmetric linear interpolation relative moving *******************
'function: Refer to current position and perform linear interpolation in asymmetric acceleration/deceleration.
'para:
'      cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      pulse1-pulse of axis 1
'      pulse2-- pulse of axis 2
'lspd --- Low speed
'  hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'      tdec--- Time of deceleration (Unit: sec)
'      vacc--- Change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct  1: wrong
'
'******************************************************************/
Public Function Unsymmetry_RelativeLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_relative_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, tdec, vacc, mode)

    Unsymmetry_RelativeLine2 = Result

End Function

'*******************Two axes asymmetric linear interpolation absolute moving*********************
'function: Refer to the position of zero point and perform linear interpolation in asymmetric acceleration/deceleration
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'pulse1-pulse of axis 1
'pulse2-- pulse of axis 2
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'tdec--- Time of deceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct  1: wrong
'
'******************************************************************/
Public Function Unsymmetry_AbsoluteLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_absolute_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, tdec, vacc, mode)

    Unsymmetry_AbsoluteLine2 = Result
    
End Function
'********************** Three axes symmetric linear interpolation relative moving********************
'function: Refer to current position and perform linear interpolation in symmetric acceleration/deceleration
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'axis3---axis number3
'pulse1-- pulse of axis 1
'pulse2-- pulse of axis 2
'pulse3-- pulse of axis 3
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct  1: wrong
'
'******************************************************************/
Public Function Symmetry_RelativeLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = symmetry_relative_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode)

    Symmetry_RelativeLine3 = Result

End Function
'*********************Three axes symmetric linear interpolation absolute moving ********************
'function: Refer to the position of zero point and perform linear interpolation in symmetric acceleration/deceleration.
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'axis3---axis number3
'pulse1-- pulse of axis 1
'pulse2-- pulse of axis 2
'pulse3-- pulse of axis 3
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'******************************************************************/
Public Function Symmetry_AbsoluteLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = symmetry_absolute_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode)

    Symmetry_AbsoluteLine3 = Result

End Function

'*********************Three axes asymmetric linear interpolation relative moving *******************
'function: Refer to current position and perform linear interpolation in asymmetric acceleration/deceleration
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'axis3---axis number3
'pulse1-- pulse of axis 1
'pulse2-- pulse of axis 2
'pulse3-- pulse of axis 3
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'tdec--- Time of deceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'******************************************************************/
Public Function Unsymmetry_RelativeLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_relative_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, tdec, vacc, mode)
    
    Unsymmetry_RelativeLine3 = Result
    
End Function
'********************** Three axes asymmetric linear interpolation absolute moving******************
'function: Refer to the position of zero point and perform linear interpolation in asymmetric acceleration/deceleration
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'axis3---axis number3
'pulse1-- pulse of axis 1
'pulse2-- pulse of axis 2
'pulse3-- pulse of axis 3
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'tdec--- Time of deceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'
'******************************************************************/
Public Function Unsymmetry_AbsoluteLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_absolute_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, tdec, vacc, mode)
    
    Unsymmetry_AbsoluteLine3 = Result
    
End Function

'********************Two axes symmetric arc interpolation relative moving*********************
'function: Refer to current position and perform arc interpolation in symmetric acceleration/deceleration.
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'xy---- Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'ij---- Centre coordinate (Refer to current point, that is, starting point of arc)
'dir----- Moving direction (0-Clockwise,1-Anti-clockwise)
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'******************************************************************/
Public Function Symmetry_Relativearc(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = symmetry_relative_arc(0, axis1, axis2, X, Y, i, j, dir, lspd, hspd, tacc, vacc, mode)

    Symmetry_Relativearc = Result

End Function

'********************** Two axes symmetric arc interpolation absolute moving ********************
'function: Refer to the position of zero point and perform arc interpolation in symmetric acceleration/deceleration
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'xy---- Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'ij---- Centre coordinate (Refer to current point, that is, starting point of arc)
'dir----- Moving direction (0-Clockwise,1-Anti-clockwise)
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'******************************************************************/
Public Function Symmetry_AbsoluteArc(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = symmetry_absolute_arc(0, axis1, axis2, X, Y, i, j, dir, lspd, hspd, tacc, vacc, mode)

    Symmetry_AbsoluteArc = Result
    
End Function
'**********************Two axes asymmetric arc interpolation relative moving******************
'function: Refer to current position and perform arc interpolation in asymmetric acceleration/deceleration
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'xy---- Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'ij---- Centre coordinate (Refer to current point, that is, starting point of arc)
'dir----- Moving direction (0-Clockwise,1-Anti-clockwise)
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'tdec--- Time of deceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'******************************************************************/
Public Function Unsymmetry_RelativeArc(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_relative_arc(0, axis1, axis2, X, Y, i, j, dir, lspd, hspd, tacc, tdec, vacc, mode)
    
    Unsymmetry_RelativeArc = Result
    
End Function
'*********************Two axes asymmetric arc interpolation absolute moving*******************
'function: Refer to current position and perform arc interpolation in asymmetric acceleration/deceleration
'para:
'cardno-card number
'axis1---axis number1
'axis2---axis number2
'xy---- Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'ij---- Centre coordinate (Refer to current point, that is, starting point of arc)
'dir----- Moving direction (0-Clockwise,1-Anti-clockwise)
'lspd --- Low speed
'hspd --- High speed
'tacc--- Time of acceleration (Unit: sec)
'tdec--- Time of deceleration (Unit: sec)
'vacc--- Change rate of acceleration/deceleration
'mode ---mode(trapezoid(0) Or S - curve(1))
'return value 0: correct 1: wrong
'
'******************************************************************/
Public Function Unsymmetry_AbsoluteArc(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Result = unsymmetry_absolute_arc(0, axis1, axis2, X, Y, i, j, dir, lspd, hspd, tacc, tdec, vacc, mode)

    Unsymmetry_AbsoluteArc = Result

End Function
